/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package com.inet.application.currenttime;

import java.net.URL;

/*
i-net software provides programming examples for illustration only, without warranty
either expressed or implied, including, but not limited to, the implied warranties
of merchantability and/or fitness for a particular purpose. This programming example
assumes that you are familiar with the programming language being demonstrated and
the tools used to create and debug procedures. i-net software support professionals
can help explain the functionality of a particular procedure, but they will not modify
these examples to provide added functionality or construct procedures to meet your
specific needs.
© i-net software 1998-2016
*/
import com.inet.permissions.Permission;
import com.inet.remote.gui.AngularModule;

/**
 * A module for our sample application. This implementation describes how the application is displayed and named (e.g.
 * icon, color, ...)
 */
public class SampleApplicationModule extends AngularModule {

    /**
     * This is the URL part after http://localhost:9000/
     * It must start with a slash. If you use "/sampleapp" then the resulting URL for your application is http://localhost:9000/sampleapp
     */
    static final String PATH = "/sampleapp";

    /**
     * {@inheritDoc}
     */
    @Override
    public String getName() {
        return "Sample App";
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getPath() {
        return PATH;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getDescription() {
        return "Sample application for the functional demonstation";
    }

    /**
     * {@inheritDoc}
     */
    @Deprecated
    @Override
    public String getIconUrl() {
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public URL getBigIconUrl( int size ) {
        if( size <= 32 ) {
            return getClass().getResource( "icon_32.png" );
        }
        if( size <= 48 ) {
            return getClass().getResource( "icon_48.png" );
        }
        return getClass().getResource( "icon_128.png" );
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean isInternal() {
        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public Permission getRequiredPermission() {
        // null means no permission is required
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String getColor() {
        return "#0047b3";
    }
}
